<?php
$embeddedSignUpAddon = $isExtendedLicence = (getAppSettings('lwAddonWhatsJetEmbeddedSignUpAddon', 'registration_id') and (sha1(array_get($_SERVER, 'HTTP_HOST', '') . getAppSettings('lwAddonWhatsJetEmbeddedSignUpAddon','registration_id') . '1.0+') === getAppSettings('lwAddonWhatsJetEmbeddedSignUpAddon','signature')));
?>
<!-- Page Heading -->
<h1>
    <?= __tr('WhatsApp Onboarding Setup') ?>
</h1>
    <form class="lw-ajax-form lw-form" method="post"
            action="<?= route('manage.configuration.write', ['pageType' => 'manual_whatsapp_onboarding']) ?>" x-cloak>
            <fieldset>
                <legend>{{  __tr('Manual Onboarding') }}</legend>
                <div class="form-group">
                    <x-lw.checkbox id="lwEnableManualWhatsAppSignup" name="enable_whatsapp_manual_signup" :offValue="0" data-lw-plugin="lwSwitchery" :checked="getAppSettings('enable_whatsapp_manual_signup')" :label="__tr('Enable Manual WhatsApp Onboarding')" />
                </div>
                <div class="form-group">
                    {{-- submit button --}}
                    <button type="submit" href class="btn btn-primary btn-user lw-btn-block-mobile">
                        <?= __tr('Save') ?>
                    </button>
                </div>
            </fieldset>
            </form>
            <form class="lw-ajax-form lw-form" method="post"
            action="<?= route('manage.configuration.write', ['pageType' => 'whatsapp_onboarding']) ?>" x-cloak
            x-data="{embeddedSignUpDataExists: {{ getAppSettings('embedded_signup_app_id') ? 1 : 0 }}}">
            <fieldset x-data="{openEmbeddedHelp:false}" x-cloak >
                <legend><i class="fab fa-facebook"></i> {{  __tr('Embedded Signup Onboarding') }}</legend>
                <fieldset>
                    <legend @click="openEmbeddedHelp = !openEmbeddedHelp">{{  __tr('Requirements and Information') }} <small class="text-muted">{{  __tr('Click to show/hide') }}</small></legend>
                    <div x-show="openEmbeddedHelp">
                        <div class="row">
                            <div class="col-12">
                            <div class="float-right">
                            <a class="btn btn-info" href="https://developers.facebook.com/docs/whatsapp/embedded-signup/"  target="_blank">{{  __tr('More Information') }}</a>
                            <a class="btn btn-info" href="https://developers.facebook.com/docs/whatsapp/solution-providers/get-started-for-tech-providers" class="float-right" target="_blank">{{  __tr('Get started for Tech Provider') }}</a>
                        </div>
                            </div>
                        </div>
                    <dl>
                        <dt>{{  __tr('Verified Meta Account') }}</dt>
                        <dd>{{  __tr('To use Embedded signup for onboarding your customers you should have Meta Verified account') }}
                        <div >
                            <a target="_blank" href="https://www.facebook.com/business/help/2058515294227817>{{  __tr('How to verify?') }}</a>
                        </div>
                        </dd>
                        <dt class="mt-4">{{  __tr('Become a Tech Provider') }}</dt>
                        <dd>{{  __tr('Follow the instructions on the given link to become tech provider so, your customers can use Embedded signup to get their account connected.') }}
                            <div>
                                <a target="_blank" href="https://developers.facebook.com/docs/whatsapp/solution-providers/get-started-for-tech-providers">{{  __tr('How to become Tech Provider?') }}</a>
                            </div>
                            <div>
                                <h4>{{  __tr('Once you become verified Tech provider all 3 items should shown in green checked mark') }}</h4>
                                <div>
                                    <img src="{{ asset('imgs/help/tech-provider.png') }}" alt="">
                                </div>
                                <div class="text-danger my-3 border rounded border-danger p-3 col-sm-12 col-md-6">
                                    <strong>{{  __tr('Important') }}</strong>
                                    <p class="mt-2 font-weight-bold">
                                        {{  __tr('1) Along with whatsapp_business_management and whatsapp_business_messaging you also needs to get public_profile and email advanced permissions from requests permissions') }}
                                    </p>
                                    <p class="font-weight-bold">
                                        {{  __tr('2) You don\'t need to create Webhook manually on app id and app secret validation it will be created automatically.') }}
                                    </p>
                                </div>
                            </div>
                        </dd>
                        <dt class="mt-4">{{  __tr('Your are almost ready') }}</dt>
                        <dd>{{  __tr('You need to set App ID, App Secret and Config ID') }}</a></dd>
                    </dl>
                    <div class="form-group col-sm-12 col-md-6 mb-4">
                        <hr>
                        @php
                            $hostRoot = request()->root();
                        @endphp
                        <label for="lwHostRoot">{{ __tr('You may need to allow following domain while configuring') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" readonly id="lwHostRoot" value="{{ $hostRoot }}">
                            <div class="input-group-append">
                                <button class="btn btn-outline-light" type="button" onclick="lwCopyToClipboard('lwHostRoot')">
                                    <?= __tr('Copy') ?>
                                </button>
                            </div>
                        </div>
                        @if (!Str::startsWith($hostRoot, 'https://'))
                            <div class="alert alert-danger my-3">
                                {{  __tr('Non https url may not accepted by Facebook.') }}
                            </div>
                        @endif
                    </div>
                    </div>
                </fieldset>
            @if(!$isExtendedLicence or isDemo())
                <div class="alert alert-warning my-3">
                    <strong><?= __tr('Embedded Signup Addon is Required') ?></strong> <br>
                    <?= __tr('To use Embedded Signup you need to have an Embedded Signup Addon.') ?>
                </div>
            @endif
            @if($isExtendedLicence)
            <div x-show="embeddedSignUpDataExists"></div>
            <div class="form-group">
                <x-lw.checkbox id="lwEmbeddedSignupEnableField" name="enable_embedded_signup" :offValue="0" data-lw-plugin="lwSwitchery" :checked="getAppSettings('enable_embedded_signup')" :label="__tr('Enable Embedded Signup')" />
            </div>
            <div class="alert alert-warning">
                {{  __tr('Please do not use the same app for any other purposes like Manual WhatsApp API Setup etc') }}
            </div>
            <div class="form-group" x-cloak x-show="embeddedSignUpDataExists">
                <div class="btn-group">
                    <button type="button" disabled="true" class="btn btn-success lw-btn">
                        {{ __tr('Embedded Signup Settings are exist') }}
                    </button>
                    <button type="button" @click="embeddedSignUpDataExists = !embeddedSignUpDataExists"
                        class="btn btn-light lw-btn">{{ __tr('Update') }}</button>
                   @if (!isDemo())
                        <a class="btn btn-muted lw-btn" target="_blank" href="https://developers.facebook.com/apps/{{ getAppSettings('embedded_signup_app_id') }}/whatsapp-business/wa-settings">{{  __tr('Go to App') }} <i class="fas fa-external-link-alt"></i></a>
                   @endif
                </div>
            </div>
            <template x-if="!embeddedSignUpDataExists">
            <div x-show="!embeddedSignUpDataExists" class="col-sm-12 col-md-6 col-lg-4">
                <a target="_blank" href="https://developers.facebook.com/docs/whatsapp/cloud-api/get-started-for-tech-providers#step-2--create-a-meta-app" class="float-right btn btn-info btn-sm">{{  __tr('Help') }} <i class="fas fa-external-link-alt"></i></a>
                <x-lw.input-field type="text" id="lwEmbeddedSignUpAppId" data-form-group-class="" :label="__tr('App ID')"
                    name="embedded_signup_app_id" />
                <x-lw.input-field type="text" id="lwEmbeddedSignUpAppSecret" data-form-group-class="" :label="__tr('App Secret')" name="embedded_signup_app_secret" />
                <a target="_blank" href="https://developers.facebook.com/docs/whatsapp/embedded-signup/embed-the-flow#step-2--create-facebook-login-for-business-configuration" class="float-right btn btn-info btn-sm mt-3">{{  __tr('Help') }} <i class="fas fa-external-link-alt"></i></a>
                <x-lw.input-field type="text" id="lwEmbeddedSignUpConfigId" data-form-group-class="" :label="__tr('Config ID')" name="embedded_signup_config_id" />
            </div>
        </template>
        <fieldset class="form-group">
                <legend class="small">{{  __tr('Existing WhatsApp Business App') }}</legend>
                <x-lw.checkbox id="lwBusinessAppOnboarding" name="enable_business_app_onboarding" data-size="small" :offValue="0" data-lw-plugin="lwSwitchery" :checked="getAppSettings('enable_business_app_onboarding')" :label="__tr('Enable WhatsApp Business App Onboarding (aka Coexistence) using Embedded Signup')" />
                <div class="text-warning help-text">
                   <em> {{  __tr('Please note once connected existing saved contacts on WhatsApp Business Mobile app will be synced but messages will not.') }}</em>
                </div>
            </fieldset>
            <div class="form-group">
                {{-- submit button --}}
                <button type="submit" href class="btn btn-primary btn-user lw-btn-block-mobile">
                    <?= __tr('Save') ?>
                </button>
            </div>
            @endif
        </form>
    @push('appScripts')
    <script>
        "use strict";
    </script>
    @endpush